/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.servicemanager;

import edu.colorado.phet.common.phetcommon.servicemanager.LocalBasicService;
import edu.colorado.phet.common.phetcommon.servicemanager.LocalFileOpenService;
import edu.colorado.phet.common.phetcommon.servicemanager.LocalFileSaveService;
import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

public class PhetServiceManager {
    public static boolean isJavaWebStart() {
        return System.getProperty("javawebstart.version") != null;
    }

    public static URL getCodeBase() {
        URL uRL = null;
        if (PhetServiceManager.isJavaWebStart()) {
            try {
                uRL = PhetServiceManager.getBasicService().getCodeBase();
            }
            catch (UnavailableServiceException unavailableServiceException) {
                unavailableServiceException.printStackTrace();
            }
        }
        return uRL;
    }

    public static BasicService getBasicService() throws UnavailableServiceException {
        if (PhetServiceManager.isJavaWebStart()) {
            return (BasicService)ServiceManager.lookup(BasicService.class.getName());
        }
        return new LocalBasicService();
    }

    public static FileOpenService getFileOpenService(Component component) throws UnavailableServiceException {
        if (PhetServiceManager.isJavaWebStart()) {
            return (FileOpenService)ServiceManager.lookup("javax.jnlp.FileOpenService");
        }
        return new LocalFileOpenService(component);
    }

    public static FileSaveService getFileSaveService(Component component) throws UnavailableServiceException {
        if (PhetServiceManager.isJavaWebStart()) {
            return (FileSaveService)ServiceManager.lookup("javax.jnlp.FileSaveService");
        }
        return new LocalFileSaveService(component);
    }

    public static void showPhetPage() {
        PhetServiceManager.showWebPage("http://phet.colorado.edu");
    }

    public static void showSimPage(String string, String string2) {
        PhetServiceManager.showWebPage(HTMLUtils.getSimWebsiteURL(string, string2));
    }

    public static void showWebPage(String string) {
        try {
            PhetServiceManager.showWebPage(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    public static void showWebPage(URL uRL) {
        try {
            PhetServiceManager.getBasicService().showDocument(uRL);
        }
        catch (UnavailableServiceException unavailableServiceException) {
            unavailableServiceException.printStackTrace();
        }
    }
}

