/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo.schematic;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.components.CircuitComponent;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.schematic.SchematicOscillateNode;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class SchematicInductorNode
extends SchematicOscillateNode {
    private PhetPPath leftBranch = new PhetPPath(new BasicStroke(6.0f * this.SCALE), (Paint)Color.black);
    private PhetPPath rightBranch = new PhetPPath(new BasicStroke(6.0f * this.SCALE), (Paint)Color.black);
    private float SCALE = 0.016666668f;

    public SchematicInductorNode(CCKModel cCKModel, CircuitComponent circuitComponent, JComponent jComponent, CCKModule cCKModule) {
        super(cCKModel, circuitComponent, jComponent, cCKModule, 0.3);
        this.addChild(this.leftBranch);
        this.addChild(this.rightBranch);
        this.changed();
        this.setVisible(true);
    }

    protected double getY(double d, double d2, double d3, double d4) {
        return Math.abs(15.0 * Math.sin((d - d2 * d3) * d4 * 1.5) * (double)this.SCALE);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.leftBranch != null) {
            this.leftBranch.setVisible(bl);
        }
    }

    protected void changed() {
        super.changed();
        if (this.leftBranch != null) {
            Point2D point2D = super.getCatPoint();
            Point2D point2D2 = this.getAnoPoint();
            Vector2D vector2D = new Vector2D(point2D, point2D2);
            ImmutableVector2D immutableVector2D = vector2D.getScaledInstance(super.getFracDistToStartSine());
            Point2D.Double double_ = immutableVector2D.getDestination(point2D);
            this.leftBranch.setPathTo(new Line2D.Double(point2D, double_));
            Point2D.Double double_2 = immutableVector2D.getScaledInstance(-1.0).getDestination(point2D2);
            this.rightBranch.setPathTo(new Line2D.Double(point2D2, double_2));
        }
    }
}

