/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.CCKResources;
import edu.colorado.phet.circuitconstructionkit.CCKStrings;
import edu.colorado.phet.circuitconstructionkit.controls.JPopupMenuRepaintWorkaround;
import edu.colorado.phet.circuitconstructionkit.controls.ResetDynamicsMenuItem;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.ACVoltageSource;
import edu.colorado.phet.circuitconstructionkit.model.components.Battery;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.Bulb;
import edu.colorado.phet.circuitconstructionkit.model.components.Capacitor;
import edu.colorado.phet.circuitconstructionkit.model.components.CircuitComponent;
import edu.colorado.phet.circuitconstructionkit.model.components.Inductor;
import edu.colorado.phet.circuitconstructionkit.model.components.Resistor;
import edu.colorado.phet.circuitconstructionkit.model.components.SeriesAmmeter;
import edu.colorado.phet.circuitconstructionkit.model.components.Switch;
import edu.colorado.phet.circuitconstructionkit.model.grabbag.GrabBagResistor;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ComponentEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class ComponentMenu
extends JPopupMenuRepaintWorkaround {
    protected CCKModule module;
    private Branch branch;
    private JCheckBoxMenuItem setVisibleItem;

    public ComponentMenu(Branch branch, CCKModule cCKModule) {
        super(cCKModule.getSimulationPanel());
        this.branch = branch;
        this.module = cCKModule;
    }

    protected JCheckBoxMenuItem createShowValueButton(JPopupMenuRepaintWorkaround jPopupMenuRepaintWorkaround, final CCKModule cCKModule, final Branch branch) {
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(CCKResources.getString("CircuitComponentInteractiveGraphic.ShowValueMenuItem"));
        jPopupMenuRepaintWorkaround.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                boolean bl = cCKModule.isReadoutVisible(branch);
                System.out.println("readoutVisibleForBranch (" + branch.hashCode() + ")= " + bl);
                jCheckBoxMenuItem.setSelected(bl);
            }
        });
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                cCKModule.setReadoutVisible(branch, jCheckBoxMenuItem.isSelected());
            }
        });
        if (branch instanceof CircuitComponent && !(branch instanceof SeriesAmmeter) && !(branch instanceof Switch) && cCKModule.getParameters().allowShowReadouts()) {
            jPopupMenuRepaintWorkaround.add(jCheckBoxMenuItem);
        }
        return jCheckBoxMenuItem;
    }

    protected void addRemoveButton(JPopupMenuRepaintWorkaround jPopupMenuRepaintWorkaround, final CCKModule cCKModule, final Branch branch) {
        JMenuItem jMenuItem = new JMenuItem(CCKResources.getString("CircuitComponentInteractiveGraphic.RemoveMenuItem"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                cCKModule.getCCKModel().getCircuit().removeBranch(branch);
            }
        });
        int n = jPopupMenuRepaintWorkaround.getComponentCount();
        if (n > 0) {
            jPopupMenuRepaintWorkaround.addSeparator();
        }
        jPopupMenuRepaintWorkaround.add(jMenuItem);
    }

    protected void addRemoveButton() {
        this.addRemoveButton(this, this.module, this.branch);
    }

    protected void addShowValueButton() {
        this.setVisibleItem = this.createShowValueButton(this, this.module, this.branch);
    }

    public JPopupMenuRepaintWorkaround getMenu() {
        return this;
    }

    protected CCKModule getModule() {
        return this.module;
    }

    public static class ACVoltageSourceMenu
    extends BatteryJMenu {
        public ACVoltageSourceMenu(Battery battery, CCKModule cCKModule) {
            super(battery, cCKModule);
        }

        protected ComponentEditor createVoltageEditor(Battery battery) {
            return new ComponentEditor.ACVoltageSourceEditor(this.getModule(), (ACVoltageSource)battery, this.getModule().getSimulationPanel(), this.getModule().getCircuit());
        }

        protected void addOptionalItemsAfterEditor() {
            super.addOptionalItemsAfterEditor();
            JMenuItem jMenuItem = new JMenuItem(CCKStrings.getString("change-frequency"));
            final ComponentEditor componentEditor = this.createFrequencyEditor((ACVoltageSource)this.getBattery());
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    componentEditor.setVisible(true);
                }
            });
            this.add(jMenuItem);
        }

        private ComponentEditor createFrequencyEditor(final ACVoltageSource aCVoltageSource) {
            return new ComponentEditor(this.getModule(), CCKResources.getString("ComponentEditor.ACFrequency"), aCVoltageSource, this.getModule().getSimulationPanel(), CCKResources.getString("ComponentEditor.Frequency"), CCKResources.getString("ComponentEditor.Hz"), 0.0, 2.0, aCVoltageSource.getFrequency(), this.getModule().getCircuit()){

                protected void doChange(double d) {
                    aCVoltageSource.setFrequency(d);
                }
            };
        }
    }

    public static class BatteryJMenu
    extends ComponentMenu {
        private Battery battery;
        private JMenuItem editInternal;
        public static final ArrayList instances = new ArrayList();
        private ComponentEditor.BatteryResistanceEditor resistanceEditor;
        private ComponentEditor editor;

        public BatteryJMenu(final Battery battery, CCKModule cCKModule) {
            super(battery, cCKModule);
            this.battery = battery;
            JMenuItem jMenuItem = new JMenuItem(CCKResources.getString("CircuitComponentInteractiveGraphic.VoltageMenuItem"));
            this.editor = this.createVoltageEditor(battery);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BatteryJMenu.this.editor.setVisible(true);
                }
            });
            this.add(jMenuItem);
            this.addOptionalItemsAfterEditor();
            this.editInternal = new JMenuItem(CCKResources.getString("CircuitComponentInteractiveGraphic.InternalResistanceMenuItem"));
            this.editInternal.setEnabled(false);
            this.resistanceEditor = new ComponentEditor.BatteryResistanceEditor(cCKModule, this.battery, cCKModule.getSimulationPanel(), cCKModule.getCircuit());
            this.editInternal.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BatteryJMenu.this.resistanceEditor.setVisible(true);
                }
            });
            this.add(this.editInternal);
            JMenuItem jMenuItem2 = new JMenuItem(CCKResources.getString("CircuitComponentInteractiveGraphic.ReverseMenuItem"));
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BatteryJMenu.this.reverse(battery);
                }
            });
            this.add(jMenuItem2);
            this.addShowValueButton();
            this.addRemoveButton();
            instances.add(this);
        }

        public Battery getBattery() {
            return this.battery;
        }

        protected void addOptionalItemsAfterEditor() {
        }

        protected ComponentEditor createVoltageEditor(Battery battery) {
            return new ComponentEditor.BatteryEditor(super.getModule(), battery, this.getModule().getSimulationPanel(), this.getModule().getCircuit());
        }

        public void show(Component component, int n, int n2) {
            this.editInternal.setEnabled(true);
            super.show(component, n, n2);
        }

        private void reverse(Battery battery) {
            Junction junction = battery.getStartJunction();
            Junction junction2 = battery.getEndJunction();
            battery.setStartJunction(junction2);
            battery.setEndJunction(junction);
            battery.notifyObservers();
            battery.fireKirkhoffChange();
        }
    }

    public static class BulbMenu
    extends ComponentMenu {
        private Bulb bulb;
        private ComponentEditor.BulbResistanceEditor editor;
        private JMenuItem flip;

        public BulbMenu(final Bulb bulb, final CCKModule cCKModule) {
            super(bulb, cCKModule);
            this.bulb = bulb;
            this.editor = new ComponentEditor.BulbResistanceEditor(cCKModule, bulb, cCKModule.getSimulationPanel(), cCKModule.getCircuit());
            JMenuItem jMenuItem = new JMenuItem(CCKResources.getString("CircuitComponentInteractiveGraphic.ResistanceMenuItem"));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BulbMenu.this.editor.setVisible(true);
                }
            });
            this.add(jMenuItem);
            this.flip = new JMenuItem(CCKResources.getString("CircuitComponentInteractiveGraphic.FlipMenuItem"));
            this.flip.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    bulb.flip(cCKModule.getCircuit());
                }
            });
            this.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    BulbMenu.this.update();
                }
            });
            this.add(this.flip);
            this.addShowValueButton();
            this.addRemoveButton();
            this.update();
        }

        private void update() {
            if (this.module.isLifelike()) {
                this.flip.setEnabled(true);
            } else {
                this.flip.setEnabled(false);
            }
            if (this.bulb.isConnectAtLeft()) {
                this.flip.setText(CCKResources.getString("CircuitComponentInteractiveGraphic.RightConnectMenuItem"));
            } else {
                this.flip.setText(CCKResources.getString("CircuitComponentInteractiveGraphic.LeftConnectMenuItem"));
            }
        }
    }

    public static class CapacitorMenu
    extends ComponentMenu {
        private Capacitor capacitor;
        private ComponentEditor editor;

        public CapacitorMenu(final Capacitor capacitor, CCKModule cCKModule) {
            super(capacitor, cCKModule);
            this.capacitor = capacitor;
            this.editor = new ComponentEditor(cCKModule, CCKStrings.getString("capacitance"), capacitor, cCKModule.getSimulationPanel(), CCKStrings.getString("capacitance"), CCKStrings.getString("farads"), 0.05, 0.2, capacitor.getCapacitance(), cCKModule.getCircuit()){

                protected void doChange(double d) {
                    capacitor.setCapacitanceConstantCharge(d);
                }
            };
            JMenuItem jMenuItem = new JMenuItem(CCKStrings.getString("edit.capacitance"));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CapacitorMenu.this.editor.setVisible(true);
                }
            });
            this.add(jMenuItem);
            this.add(new ResetDynamicsMenuItem(CCKStrings.getString("discharge.capacitor"), capacitor));
            this.addShowValueButton();
            this.addRemoveButton();
        }
    }

    public static class DefaultComponentMenu
    extends ComponentMenu {
        public DefaultComponentMenu(Branch branch, CCKModule cCKModule) {
            super(branch, cCKModule);
            this.addShowValueButton();
            this.addRemoveButton();
        }
    }

    public static class GrabBagResistorMenu
    extends ComponentMenu {
        public GrabBagResistorMenu(GrabBagResistor grabBagResistor, CCKModule cCKModule) {
            super(grabBagResistor, cCKModule);
            this.addRemoveButton(this.getMenu(), cCKModule, grabBagResistor);
        }
    }

    public static class InductorMenu
    extends ComponentMenu {
        private Inductor inductor;
        private ComponentEditor editor;

        public InductorMenu(final Inductor inductor, CCKModule cCKModule) {
            super(inductor, cCKModule);
            this.inductor = inductor;
            this.editor = new ComponentEditor(cCKModule, CCKStrings.getString("inductance"), inductor, cCKModule.getSimulationPanel(), CCKStrings.getString("inductance"), CCKStrings.getString("henries"), 10.0, 100.0, inductor.getInductance(), cCKModule.getCircuit()){

                protected void doChange(double d) {
                    inductor.setInductance(d);
                }
            };
            JMenuItem jMenuItem = new JMenuItem(CCKStrings.getString("edit.inductance"));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    InductorMenu.this.editor.setVisible(true);
                }
            });
            this.add(jMenuItem);
            this.add(new ResetDynamicsMenuItem(CCKStrings.getString("discharge.inductor"), inductor));
            this.addShowValueButton();
            this.addRemoveButton();
        }
    }

    public static class ResistorMenu
    extends ComponentMenu {
        private Resistor res;
        private ComponentEditor.ResistorEditor editor;

        public ResistorMenu(Resistor resistor, CCKModule cCKModule) {
            super(resistor, cCKModule);
            this.res = resistor;
            if (resistor instanceof GrabBagResistor) {
                this.addRemoveButton(this.getMenu(), cCKModule, resistor);
            } else {
                this.editor = new ComponentEditor.ResistorEditor(cCKModule, resistor, cCKModule.getSimulationPanel(), cCKModule.getCircuit());
                JMenuItem jMenuItem = new JMenuItem(CCKResources.getString("CircuitComponentInteractiveGraphic.ResistanceMenuItem"));
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ResistorMenu.this.editor.setVisible(true);
                    }
                });
                this.add(jMenuItem);
                this.addShowValueButton();
                this.addRemoveButton();
            }
        }
    }

    public static class SeriesAmmeterMenu
    extends DefaultComponentMenu {
        public SeriesAmmeterMenu(Branch branch, CCKModule cCKModule) {
            super(branch, cCKModule);
        }
    }

    public static class SwitchMenu
    extends DefaultComponentMenu {
        public SwitchMenu(Branch branch, CCKModule cCKModule) {
            super(branch, cCKModule);
        }
    }
}

