/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.updates;

import edu.colorado.phet.common.phetcommon.application.ISimInfo;
import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.VersionInfoQuery;
import edu.colorado.phet.common.phetcommon.files.PhetInstallation;
import edu.colorado.phet.common.phetcommon.resources.PhetInstallerVersion;
import edu.colorado.phet.common.phetcommon.resources.PhetVersion;
import edu.colorado.phet.common.phetcommon.updates.IAskMeLaterStrategy;
import edu.colorado.phet.common.phetcommon.updates.IVersionSkipper;
import edu.colorado.phet.common.phetcommon.updates.InstallerAskMeLaterStrategy;
import edu.colorado.phet.common.phetcommon.updates.SimAskMeLaterStrategy;
import edu.colorado.phet.common.phetcommon.updates.SimVersionSkipper;
import edu.colorado.phet.common.phetcommon.updates.dialogs.InstallerAutomaticUpdateDialog;
import edu.colorado.phet.common.phetcommon.updates.dialogs.SimAutomaticUpdateDialog;
import edu.colorado.phet.common.phetcommon.util.DeploymentScenario;
import java.awt.Frame;
import java.net.UnknownHostException;
import javax.swing.SwingUtilities;

public class AutomaticUpdatesManager {
    private static AutomaticUpdatesManager instance;
    private final ISimInfo simInfo;
    private final Frame parentFrame;
    private final IVersionSkipper simVersionSkipper;
    private final IAskMeLaterStrategy simAskMeLaterStrategy;
    private final IAskMeLaterStrategy installerAskMeLaterStrategy;
    private boolean started;

    private AutomaticUpdatesManager(PhetApplication phetApplication) {
        this.simInfo = phetApplication.getSimInfo();
        this.parentFrame = phetApplication.getPhetFrame();
        this.simVersionSkipper = new SimVersionSkipper(this.simInfo.getProjectName(), this.simInfo.getFlavor());
        this.simAskMeLaterStrategy = new SimAskMeLaterStrategy(this.simInfo.getProjectName(), this.simInfo.getFlavor());
        this.installerAskMeLaterStrategy = new InstallerAskMeLaterStrategy();
        this.started = false;
    }

    public static AutomaticUpdatesManager initInstance(PhetApplication phetApplication) {
        if (instance != null) {
            throw new RuntimeException("instance is already initialized");
        }
        instance = new AutomaticUpdatesManager(phetApplication);
        return instance;
    }

    public void start() {
        if (this.started) {
            throw new IllegalStateException("attempted to call start more than once");
        }
        this.started = true;
        if (this.simInfo.isUpdatesEnabled() && this.simAskMeLaterStrategy.isDurationExceeded()) {
            this.runUpdateCheckThread();
        }
    }

    private void runUpdateCheckThread() {
        Object object;
        VersionInfoQuery versionInfoQuery = null;
        if (DeploymentScenario.getInstance() == DeploymentScenario.PHET_INSTALLATION) {
            object = PhetInstallation.getInstance().getInstallerVersion();
            versionInfoQuery = new VersionInfoQuery(this.simInfo, (PhetInstallerVersion)object, true);
        } else {
            versionInfoQuery = new VersionInfoQuery(this.simInfo, true);
        }
        versionInfoQuery.addListener(new VersionInfoQuery.VersionInfoQueryListener(){

            public void done(final VersionInfoQuery.Response response) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PaintImmediateDialog paintImmediateDialog;
                        Object object;
                        Object object2;
                        VersionInfoQuery.InstallerResponse installerResponse = response.getInstallerResponse();
                        if (installerResponse != null) {
                            AutomaticUpdatesManager.this.installerAskMeLaterStrategy.setDuration(installerResponse.getAskMeLaterDuration());
                            if (DeploymentScenario.getInstance() == DeploymentScenario.PHET_INSTALLATION && installerResponse.isUpdateRecommended() && AutomaticUpdatesManager.this.installerAskMeLaterStrategy.isDurationExceeded()) {
                                object2 = response.getQuery().getCurrentInstallerVersion();
                                object = installerResponse.getVersion();
                                paintImmediateDialog = new InstallerAutomaticUpdateDialog(AutomaticUpdatesManager.this.parentFrame, AutomaticUpdatesManager.this.installerAskMeLaterStrategy, (PhetInstallerVersion)object2, (PhetInstallerVersion)object);
                                paintImmediateDialog.setVisible(true);
                            }
                        }
                        if ((object2 = response.getSimResponse()) != null) {
                            AutomaticUpdatesManager.this.simAskMeLaterStrategy.setDuration(((VersionInfoQuery.SimResponse)object2).getAskMeLaterDuration());
                            object = ((VersionInfoQuery.SimResponse)object2).getVersion();
                            if (((VersionInfoQuery.SimResponse)object2).isUpdateRecommended() && !AutomaticUpdatesManager.this.simVersionSkipper.isSkipped(((PhetVersion)object).getRevisionAsInt()) && AutomaticUpdatesManager.this.simAskMeLaterStrategy.isDurationExceeded()) {
                                paintImmediateDialog = new SimAutomaticUpdateDialog(AutomaticUpdatesManager.this.parentFrame, AutomaticUpdatesManager.this.simInfo, (PhetVersion)object, AutomaticUpdatesManager.this.simAskMeLaterStrategy, AutomaticUpdatesManager.this.simVersionSkipper);
                                paintImmediateDialog.setVisible(true);
                            }
                        }
                    }
                });
            }

            public void exception(Exception exception) {
                if (exception instanceof UnknownHostException) {
                    System.out.println(this.getClass().getName() + ": cannot connect, " + exception.toString());
                } else {
                    exception.printStackTrace();
                }
            }
        });
        object = versionInfoQuery;
        Thread thread = new Thread(new Runnable((VersionInfoQuery)object){
            final /* synthetic */ VersionInfoQuery val$finalQuery;
            {
                this.val$finalQuery = versionInfoQuery;
            }

            public void run() {
                this.val$finalQuery.send();
            }
        });
        thread.start();
    }
}

