/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.application.SoftwareAgreement;
import edu.colorado.phet.common.phetcommon.resources.DefaultResourceLoader;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;

public class SoftwareAgreementDialog
extends PaintImmediateDialog {
    private static final Dimension PREFERRED_SIZE = new Dimension(700, 400);
    private static final String TITLE = PhetCommonResources.getString("Common.softwareAgreement.title");
    private static final String CLOSE_BUTTON = PhetCommonResources.getString("Common.choice.close");

    public SoftwareAgreementDialog(Frame frame) {
        super(frame);
        this.init();
    }

    public SoftwareAgreementDialog(Dialog dialog) {
        super(dialog);
        this.init();
    }

    private void init() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(true);
        JComponent jComponent = this.createAgreementPanel();
        JPanel jPanel = this.createButtonPanel();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel2.add((Component)jComponent, "Center");
        jPanel2.add((Component)jPanel, "South");
        jPanel2.setPreferredSize(PREFERRED_SIZE);
        this.setContentPane(jPanel2);
        this.pack();
        SwingUtils.centerDialogInParent(this);
    }

    protected JComponent createAgreementPanel() {
        String string = HTMLUtils.createStyledHTMLFromFragment(SoftwareAgreement.getInstance().getContent());
        HTMLUtils.InteractiveHTMLPane interactiveHTMLPane = new HTMLUtils.InteractiveHTMLPane(string);
        final HTMLFactoryWithImages hTMLFactoryWithImages = new HTMLFactoryWithImages();
        interactiveHTMLPane.setEditorKit(new HTMLEditorKit(){

            public ViewFactory getViewFactory() {
                return hTMLFactoryWithImages;
            }
        });
        interactiveHTMLPane.setText(string);
        interactiveHTMLPane.setBackground(Color.WHITE);
        JScrollPane jScrollPane = new JScrollPane(interactiveHTMLPane);
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width + 30, 300));
        interactiveHTMLPane.setCaretPosition(0);
        return jScrollPane;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(CLOSE_BUTTON);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SoftwareAgreementDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    private class HTMLFactoryWithImages
    extends HTMLEditorKit.HTMLFactory {
        private HTMLFactoryWithImages() {
        }

        public View create(Element element) {
            Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (object instanceof HTML.Tag) {
                HTML.Tag tag = (HTML.Tag)object;
                if (tag == HTML.Tag.IMG) {
                    return new HTMLTagImageView(element);
                }
                return super.create(element);
            }
            return super.create(element);
        }
    }

    private class HTMLTagImageView
    extends ImageView {
        public HTMLTagImageView(Element element) {
            super(element);
        }

        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            String string = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
            BufferedImage bufferedImage = new DefaultResourceLoader().getImage(string);
            graphics.drawImage(bufferedImage, rectangle.x, rectangle.y, ((Image)bufferedImage).getWidth(null), ((Image)bufferedImage).getHeight(null), null);
        }
    }
}

