/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.components.Resistor;
import edu.colorado.phet.circuitconstructionkit.view.CCKImageSuite;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ComponentImageNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ResistorColors;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;

public class ResistorNode
extends ComponentImageNode {
    private Resistor resistor;
    private CCKModule module;
    private ColorBandNode colorBandNode;
    private SimpleObserver resistorObserver = new SimpleObserver(){

        public void update() {
            ResistorNode.this.update();
        }
    };

    public ResistorNode(CCKModel cCKModel, Resistor resistor, JComponent jComponent, CCKModule cCKModule) {
        super(cCKModel, resistor, CCKImageSuite.getInstance().getLifelikeSuite().getResistorImage(), jComponent, cCKModule);
        this.resistor = resistor;
        this.module = cCKModule;
        this.colorBandNode = new ColorBandNode(this, resistor);
        this.addChild(this.colorBandNode);
        resistor.addObserver(this.resistorObserver);
    }

    public void delete() {
        super.delete();
        this.resistor.removeObserver(this.resistorObserver);
    }

    protected void update() {
        super.update();
        if (this.colorBandNode != null) {
            this.colorBandNode.update();
        }
    }

    public class ColorBandNode
    extends PhetPNode {
        private ComponentImageNode node;
        private Resistor resistor;

        public ColorBandNode(ComponentImageNode componentImageNode, Resistor resistor) {
            this.node = componentImageNode;
            this.resistor = resistor;
            this.update();
        }

        public void update() {
            this.removeAllChildren();
            int n = (int)this.resistor.getResistance();
            Color[] colorArray = new ResistorColors().to3Colors(n);
            int n2 = 2;
            int n3 = 5;
            int n4 = 22;
            PhetPPath phetPPath = new PhetPPath((Shape)new Rectangle(22, n2, n3, n4), (Paint)colorArray[0]);
            this.addChild(phetPPath);
            this.addChild(new PhetPPath((Shape)new Rectangle(32, n2, n3, n4), (Paint)colorArray[1]));
            this.addChild(new PhetPPath((Shape)new Rectangle(42, n2, n3, n4), (Paint)colorArray[2]));
            if (colorArray[3] != null) {
                this.addChild(new PhetPPath((Shape)new Rectangle(53, n2, n3, n4), (Paint)colorArray[3]));
            }
        }
    }
}

