/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.Bulb;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.BranchNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike.BulbComponentNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike.FilamentNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import java.awt.Shape;
import javax.swing.JComponent;

public class TotalBulbComponentNode
extends BranchNode {
    private Bulb bulb;
    private FilamentNode filamentNode;
    private BulbComponentNode bulbComponentNode;

    public TotalBulbComponentNode(CCKModel cCKModel, Bulb bulb, JComponent jComponent, CCKModule cCKModule) {
        this.bulb = bulb;
        this.filamentNode = new FilamentNode(bulb.getFilament(), this);
        this.bulbComponentNode = new BulbComponentNode(cCKModel, bulb, jComponent, cCKModule);
        this.addChild(this.bulbComponentNode);
        this.addChild(this.filamentNode);
    }

    public BulbComponentNode getBulbComponentNode() {
        return this.bulbComponentNode;
    }

    public Branch getBranch() {
        return this.bulb;
    }

    public void delete() {
        this.filamentNode.delete();
        this.bulbComponentNode.delete();
    }

    public Shape getClipShape(PNode pNode) {
        Shape shape = this.getBulbComponentNode().getBulbNode().getCoverShapeOnFilamentSide();
        PAffineTransform pAffineTransform = this.getBulbComponentNode().getBulbNode().getLocalToGlobalTransform(null);
        PAffineTransform pAffineTransform2 = pNode.getGlobalToLocalTransform(null);
        shape = pAffineTransform.createTransformedShape(shape);
        shape = pAffineTransform2.createTransformedShape(shape);
        return shape;
    }

    public Bulb getBulb() {
        return this.bulb;
    }
}

