/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.CCKStrings;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.ACVoltageSource;
import edu.colorado.phet.circuitconstructionkit.model.components.Battery;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.Bulb;
import edu.colorado.phet.circuitconstructionkit.model.components.Capacitor;
import edu.colorado.phet.circuitconstructionkit.model.components.Inductor;
import edu.colorado.phet.circuitconstructionkit.model.components.Resistor;
import edu.colorado.phet.circuitconstructionkit.model.components.SeriesAmmeter;
import edu.colorado.phet.circuitconstructionkit.model.components.Switch;
import edu.colorado.phet.circuitconstructionkit.model.components.Wire;
import edu.colorado.phet.circuitconstructionkit.view.CCKLookAndFeel;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.BranchNodeFactory;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CCKSimulationPanel;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CircuitInteractionModel;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike.BulbComponentNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike.BulbNode;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class ToolboxNode
extends PhetPNode {
    private PPath toolboxBounds;
    private PhetPCanvas canvas;
    private CCKModel model;
    private BranchNodeFactory branchNodeFactory;
    private CCKSimulationPanel cckSimulationPanel;
    private BooleanProperty lifelikeProperty;
    private ArrayList branchMakers = new ArrayList();
    private double betweenInset = 6.0;
    private CircuitInteractionModel circuitInteractionModel;
    private CCKModule module;
    private AmmeterMaker ammeterMaker;
    private WireMaker wireMaker;
    private static double batteryScale = 0.75;

    public ToolboxNode(PhetPCanvas phetPCanvas, CCKModel cCKModel, CCKModule cCKModule, BranchNodeFactory branchNodeFactory, CCKSimulationPanel cCKSimulationPanel, BooleanProperty booleanProperty) {
        this.module = cCKModule;
        this.canvas = phetPCanvas;
        this.model = cCKModel;
        this.branchNodeFactory = branchNodeFactory;
        this.cckSimulationPanel = cCKSimulationPanel;
        this.lifelikeProperty = booleanProperty;
        this.circuitInteractionModel = new CircuitInteractionModel(cCKModel);
        this.toolboxBounds = new PPath(new Rectangle(100, 100));
        this.toolboxBounds.setStroke(new BasicStroke(2.0f, 1, 2));
        this.toolboxBounds.setPaint(CCKLookAndFeel.toolboxColor);
        this.addChild(this.toolboxBounds);
        if (!this.getAllowsDynamics()) {
            this.betweenInset = 40.0;
        }
        this.wireMaker = new WireMaker();
        this.addBranchMaker(this.wireMaker);
        this.addBranchMaker(new ResistorMaker());
        this.addBranchMaker(new BatteryMaker());
        this.addBranchMaker(new BulbMaker());
        this.addBranchMaker(new SwitchMaker());
        if (this.getAllowsDynamics()) {
            this.addBranchMaker(new ACVoltageMaker());
            this.addBranchMaker(new CapacitorMaker());
            this.addBranchMaker(new InductorMaker());
        }
        this.ammeterMaker = new AmmeterMaker();
        this.addBranchMaker(this.ammeterMaker);
        this.toolboxBounds.setPathTo(new Rectangle2D.Double(0.0, 0.0, 100.0, this.getYForNextItem(new ResistorMaker())));
        this.setSeriesAmmeterVisible(false);
    }

    private boolean getAllowsDynamics() {
        return this.module.getParameters().getAllowDynamics();
    }

    private void addBranchMaker(BranchMaker branchMaker) {
        double d = this.getYForNextItem(branchMaker);
        branchMaker.setOffset(this.toolboxBounds.getFullBounds().getCenterX() - branchMaker.getFullBounds().getWidth() / 2.0 - branchMaker.getFullBounds().getMinX(), d);
        this.addChild(branchMaker);
        this.branchMakers.add(branchMaker);
    }

    private double getYForNextItem(BranchMaker branchMaker) {
        if (this.branchMakers.size() == 0) {
            return 30.0;
        }
        BranchMaker branchMaker2 = (BranchMaker)this.branchMakers.get(this.branchMakers.size() - 1);
        double d = branchMaker2.getFullBounds().getMaxY() + this.betweenInset;
        if (branchMaker.getFullBounds().getMinY() < 0.0) {
            d -= branchMaker.getFullBounds().getMinY();
        }
        return d;
    }

    public void setBackground(Paint paint) {
        this.toolboxBounds.setPaint(paint);
    }

    public Color getBackgroundColor() {
        return (Color)this.toolboxBounds.getPaint();
    }

    public void setSeriesAmmeterVisible(boolean bl) {
        this.ammeterMaker.setVisible(bl);
    }

    public WireMaker getWireMaker() {
        return this.wireMaker;
    }

    class ACVoltageMaker
    extends BranchMaker {
        public ACVoltageMaker() {
            super(CCKStrings.getString("BranchSource.AC"), 60.0);
        }

        protected Branch createBranch() {
            return this.createSwitch();
        }

        private ACVoltageSource createSwitch() {
            return new ACVoltageSource(ToolboxNode.this.model.getCircuitChangeListener(), new Junction(0.0, 0.0), new Junction(1.0, 0.0), 1.0, 1.0, 0.01, true);
        }
    }

    class AmmeterMaker
    extends BranchMaker {
        public AmmeterMaker() {
            super(CCKStrings.getString("BranchSource.Ammeter"), 30.0);
        }

        protected Branch createBranch() {
            return this.createAmmeter();
        }

        private SeriesAmmeter createAmmeter() {
            double d = 2.0;
            return new SeriesAmmeter(ToolboxNode.this.model.getCircuitChangeListener(), new Junction(0.0, 0.0), new Junction(d, 0.0), d, 0.6);
        }
    }

    class BatteryMaker
    extends BranchMaker {
        public BatteryMaker() {
            super(CCKStrings.getString("BranchSource.Battery"), 45.0 / batteryScale);
        }

        protected Branch createBranch() {
            return this.createBattery();
        }

        private Battery createBattery() {
            double d = 1.6 * batteryScale;
            return new Battery(ToolboxNode.this.model.getCircuitChangeListener(), new Junction(0.0, 0.0), new Junction(d, 0.0), d, 1.8, 1.0E-4, true);
        }
    }

    abstract class BranchMaker
    extends PComposite {
        private PText label;
        private Branch createdBranch;
        private double scale;

        public BranchMaker(String string, double d) {
            this.scale = d;
            this.label = new PText(string);
            this.label.setFont(this.createFont());
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new PBasicInputEventHandler(){

                public void mouseDragged(PInputEvent pInputEvent) {
                    if (BranchMaker.this.createdBranch == null) {
                        BranchMaker.this.createdBranch = BranchMaker.this.createBranch();
                        BranchMaker.this.setBranchLocationFromEvent(pInputEvent);
                        ToolboxNode.this.model.getCircuit().addBranch(BranchMaker.this.createdBranch);
                        ToolboxNode.this.model.getCircuit().setSelection(BranchMaker.this.createdBranch);
                    }
                    ToolboxNode.this.circuitInteractionModel.translate(BranchMaker.this.createdBranch, BranchMaker.this.getWorldLocation(pInputEvent));
                }

                public void mouseReleased(PInputEvent pInputEvent) {
                    if (BranchMaker.this.createdBranch != null) {
                        ToolboxNode.this.circuitInteractionModel.dropBranch(BranchMaker.this.createdBranch);
                        BranchMaker.this.createdBranch = null;
                    }
                }
            });
            this.setupNode(d);
        }

        protected void setupNode(double d) {
            PNode pNode = this.createNode(this.createBranch());
            pNode.scale(d);
            this.setDisplayGraphic(pNode);
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            this.setPickable(bl);
            this.setChildrenPickable(bl);
        }

        private Font createFont() {
            return new PhetFont(16);
        }

        public Point2D getWorldLocation(PInputEvent pInputEvent) {
            Point2D point2D = pInputEvent.getPositionRelativeTo(this);
            this.localToGlobal(point2D);
            CCKModule cCKModule = ToolboxNode.this.module;
            cCKModule.getCckSimulationPanel().getCircuitNode().globalToLocal(point2D);
            return point2D;
        }

        private void setBranchLocationFromEvent(PInputEvent pInputEvent) {
            Point2D point2D = this.getWorldLocation(pInputEvent);
            double d = this.createdBranch.getEndPoint().getX() - this.createdBranch.getStartPoint().getX();
            double d2 = this.createdBranch.getEndPoint().getY() - this.createdBranch.getStartPoint().getY();
            this.createdBranch.getStartJunction().setPosition(point2D.getX() - d / 2.0, point2D.getY() - d2 / 2.0);
            this.createdBranch.getEndJunction().setPosition(point2D.getX() + d / 2.0, point2D.getY() + d2 / 2.0);
        }

        protected abstract Branch createBranch();

        public void setDisplayGraphic(PNode pNode) {
            this.addChild(pNode);
            this.addChild(this.label);
            double d = 4.0;
            this.label.setOffset(pNode.getFullBounds().getWidth() / 2.0 - this.label.getFullBounds().getWidth() / 2.0, pNode.getFullBounds().getMaxY() + d);
        }

        public PNode createNode(Branch branch) {
            return ToolboxNode.this.branchNodeFactory.createNode(branch);
        }
    }

    class BulbMaker
    extends BranchMaker {
        public BulbMaker() {
            super(CCKStrings.getString("BranchSource.LightBulb"), 1.0);
            BulbNode bulbNode = new BulbNode(this.createBulb());
            bulbNode.transformBy(AffineTransform.getScaleInstance(50.0, 75.0));
            this.setDisplayGraphic(bulbNode);
        }

        protected void setupNode(double d) {
        }

        protected Branch createBranch() {
            return this.createBulb();
        }

        private Bulb createBulb() {
            Bulb bulb = new Bulb(ToolboxNode.this.model.getCircuitChangeListener(), new Junction(0.0, 0.0), new Junction(1.0, 0.0), 1.0, 1.0, 0.01, true);
            double d = BulbComponentNode.getTiltValue(bulb);
            Bulb bulb2 = new Bulb(new Point(), Vector2D.parseAngleAndMagnitude(1.0, -d - 1.5707963267948966), 0.43, 1.0, 1.0, ToolboxNode.this.model.getCircuitChangeListener());
            bulb2.flip(null);
            return bulb2;
        }
    }

    class CapacitorMaker
    extends BranchMaker {
        public CapacitorMaker() {
            super(CCKStrings.getString("BranchSource.Capacitor"), 60.0);
        }

        protected Branch createBranch() {
            return this.createCapacitor();
        }

        private Capacitor createCapacitor() {
            return new Capacitor(ToolboxNode.this.model.getCircuitChangeListener(), new Junction(0.0, 0.0), new Junction(1.0, 0.0), 1.0, 1.0);
        }
    }

    class InductorMaker
    extends BranchMaker {
        public InductorMaker() {
            super(CCKStrings.getString("BranchSource.Inductor"), 42.0);
        }

        protected Branch createBranch() {
            return this.createInductor();
        }

        private Inductor createInductor() {
            double d = 1.2;
            return new Inductor(ToolboxNode.this.model.getCircuitChangeListener(), new Junction(0.0, 0.0), new Junction(d, 0.0), d, 0.4);
        }
    }

    class ResistorMaker
    extends BranchMaker {
        public ResistorMaker() {
            super(CCKStrings.getString("BranchSource.Resistor"), 60.0);
        }

        protected Branch createBranch() {
            double d = CCKModel.RESISTOR_DIMENSION.getLength() * 1.3 * 1.3;
            double d2 = CCKModel.RESISTOR_DIMENSION.getHeight() * 1.3 * 1.3;
            Resistor resistor = new Resistor(ToolboxNode.this.model.getCircuitChangeListener(), new Junction(0.0, 0.0), new Junction(d, 0.0), d, d2);
            resistor.setResistance(10.0);
            return resistor;
        }
    }

    class SwitchMaker
    extends BranchMaker {
        public SwitchMaker() {
            super(CCKStrings.getString("BranchSource.Switch"), 60.0);
        }

        protected Branch createBranch() {
            return this.createSwitch();
        }

        private Switch createSwitch() {
            return new Switch(ToolboxNode.this.model.getCircuitChangeListener(), new Junction(0.0, 0.0), new Junction(1.0, 0.0), false, 1.0, 1.0);
        }
    }

    class WireMaker
    extends BranchMaker {
        public WireMaker() {
            super(CCKStrings.getString("BranchSource.Wire"), 40.0);
        }

        protected Branch createBranch() {
            Wire wire = new Wire(ToolboxNode.this.model.getCircuitChangeListener(), new Junction(0.0, 0.0), new Junction(1.5, 0.0));
            wire.setThickness((Boolean)ToolboxNode.this.lifelikeProperty.get() != false ? 0.32789999999999997 : 0.19673999999999997);
            return wire;
        }
    }
}

