/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.ShadowHTMLNode;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Arrays;

public class TargetReadoutToolNode
extends PComposite {
    private RoundRectangle2D.Double bounds;
    private int crosshairRadius = 15;
    private int readoutWidth = 140;
    private int readoutHeight = 50;
    private int width = this.crosshairRadius * 2 + this.readoutWidth + 30;
    private int height = this.readoutHeight + 20;
    private Stroke crossHairStroke = new BasicStroke(1.0f);
    private Stroke holeStroke = new BasicStroke(2.0f);
    private int boundsStrokeWidth = 2;
    private Stroke boundsStroke = new BasicStroke(this.boundsStrokeWidth);
    private PhetPPath background;
    private PhetPPath roundRect;
    private PhetPPath portHole;
    private PhetPPath upCrossHairGraphic;
    private PhetPPath readoutShapeGraphic;
    private ShadowHTMLNode textNode;
    private String[] text = new String[0];
    private PhetPPath rightCrossHairGraphic;

    public TargetReadoutToolNode() {
        this.background = new PhetPPath(new Color(255, 255, 255, 128));
        this.roundRect = new PhetPPath(this.boundsStroke, (Paint)Color.black);
        this.portHole = new PhetPPath(this.holeStroke, (Paint)Color.black);
        this.rightCrossHairGraphic = new PhetPPath(this.crossHairStroke, (Paint)Color.black);
        this.upCrossHairGraphic = new PhetPPath(this.crossHairStroke, (Paint)Color.black);
        this.readoutShapeGraphic = new PhetPPath(Color.white, this.crossHairStroke, (Paint)Color.black);
        this.textNode = new ShadowHTMLNode("HELLO");
        this.textNode.setShadowColor(Color.lightGray);
        this.textNode.setShadowOffset(0.5, 0.5);
        this.addChild(this.background);
        this.addChild(this.roundRect);
        this.addChild(this.portHole);
        this.addChild(this.rightCrossHairGraphic);
        this.addChild(this.upCrossHairGraphic);
        this.addChild(this.readoutShapeGraphic);
        this.addChild(this.textNode);
        this.update();
    }

    private void update() {
        Point point = new Point(-this.crosshairRadius, -this.crosshairRadius);
        Point point2 = new Point(point.x + this.crosshairRadius * 2 + 10, point.y + this.crosshairRadius - this.readoutHeight / 2);
        this.bounds = new RoundRectangle2D.Double(point.x - 10, point.y + this.crosshairRadius - this.readoutHeight / 2 - 10, this.width, this.height, 5.0, 5.0);
        Ellipse2D.Double double_ = new Ellipse2D.Double(point.x, point.y, this.crosshairRadius * 2, this.crosshairRadius * 2);
        Area area = new Area(this.bounds);
        area.subtract(new Area(double_));
        this.background.setPathTo(area);
        RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double(point.x - 10, point.y + this.crosshairRadius - this.readoutHeight / 2 - 10, this.crosshairRadius * 2 + this.readoutWidth + 30, this.readoutHeight + 20, 5.0, 5.0);
        this.roundRect.setPathTo(double_2);
        Ellipse2D.Double double_3 = new Ellipse2D.Double(point.x, point.y, this.crosshairRadius * 2, this.crosshairRadius * 2);
        this.portHole.setPathTo(double_3);
        Line2D.Double double_4 = new Line2D.Double(point.x + this.crosshairRadius, point.y, point.x + this.crosshairRadius, point.y + this.crosshairRadius * 2);
        Line2D.Double double_5 = new Line2D.Double(point.x, point.y + this.crosshairRadius, point.x + this.crosshairRadius * 2, point.y + this.crosshairRadius);
        this.upCrossHairGraphic.setPathTo(double_4);
        this.rightCrossHairGraphic.setPathTo(double_5);
        this.readoutShapeGraphic.setPathTo(new Rectangle2D.Double(point2.x, point2.y, this.readoutWidth, this.readoutHeight));
        this.textNode.setHtml(this.text);
        this.textNode.setOffset(point2.x + 5, (double)(point2.y + this.readoutHeight / 2) - this.textNode.getFullBounds().getHeight() / 2.0);
    }

    public void setText(String[] stringArray) {
        if (!((Object)Arrays.asList(stringArray)).equals(Arrays.asList(this.text))) {
            this.text = stringArray;
            this.update();
        }
    }

    public void setText(String string) {
        this.setText(new String[]{string});
    }
}

