/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class FlameNode
extends PhetPNode {
    private Branch branch;
    private BufferedImage flameImage;

    public FlameNode(Branch branch) {
        this.branch = branch;
        try {
            this.flameImage = ImageLoader.loadBufferedImage("circuit-construction-kit/images/flame.gif");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        branch.addFlameListener(new Branch.FlameListener(){

            public void flameStarted() {
                FlameNode.this.update();
            }

            public void flameFinished() {
                FlameNode.this.update();
            }
        });
        this.update();
        this.setPickable(false);
        this.setChildrenPickable(false);
    }

    private void update() {
        this.removeAllChildren();
        if (this.branch.isOnFire()) {
            this.addChild(new PImage(this.flameImage));
        }
    }
}

