/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.components.ACVoltageSource;
import edu.colorado.phet.circuitconstructionkit.model.components.Battery;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.Bulb;
import edu.colorado.phet.circuitconstructionkit.model.components.Capacitor;
import edu.colorado.phet.circuitconstructionkit.model.components.Inductor;
import edu.colorado.phet.circuitconstructionkit.model.components.Resistor;
import edu.colorado.phet.circuitconstructionkit.model.components.SeriesAmmeter;
import edu.colorado.phet.circuitconstructionkit.model.components.Switch;
import edu.colorado.phet.circuitconstructionkit.model.components.Wire;
import edu.colorado.phet.circuitconstructionkit.model.grabbag.GrabBagResistor;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ComponentMenu;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.WirePopupMenu;
import javax.swing.JPopupMenu;

public class CCKPopupMenuFactory {
    private CCKModule module;

    public CCKPopupMenuFactory(CCKModule cCKModule) {
        this.module = cCKModule;
    }

    public JPopupMenu createPopupMenu(Branch branch) {
        if (branch instanceof Switch) {
            return new ComponentMenu.SwitchMenu((Switch)branch, this.module);
        }
        if (branch instanceof SeriesAmmeter) {
            return new ComponentMenu.SeriesAmmeterMenu((SeriesAmmeter)branch, this.module);
        }
        if (branch instanceof ACVoltageSource) {
            return new ComponentMenu.ACVoltageSourceMenu((Battery)branch, this.module);
        }
        if (branch instanceof Battery) {
            return new ComponentMenu.BatteryJMenu((Battery)branch, this.module);
        }
        if (branch instanceof Bulb) {
            return new ComponentMenu.BulbMenu((Bulb)branch, this.module);
        }
        if (branch instanceof Capacitor) {
            return new ComponentMenu.CapacitorMenu((Capacitor)branch, this.module);
        }
        if (branch instanceof GrabBagResistor) {
            return new ComponentMenu.GrabBagResistorMenu((GrabBagResistor)branch, this.module);
        }
        if (branch instanceof Inductor) {
            return new ComponentMenu.InductorMenu((Inductor)branch, this.module);
        }
        if (branch instanceof Resistor) {
            return new ComponentMenu.ResistorMenu((Resistor)branch, this.module);
        }
        if (branch instanceof Wire) {
            return new WirePopupMenu(this.module.getCCKModel(), branch);
        }
        System.out.println("No popup menu found for component: " + branch);
        return null;
    }
}

