/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model;

import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.CircuitListenerAdapter;
import edu.colorado.phet.circuitconstructionkit.model.ConstantDensityPropagator;
import edu.colorado.phet.circuitconstructionkit.model.Electron;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import java.util.ArrayList;

public class ElectronSet
implements ModelElement {
    private ArrayList<Electron> particles = new ArrayList();
    private ConstantDensityPropagator propagator;
    private ArrayList<Listener> listeners = new ArrayList();

    public ElectronSet(Circuit circuit) {
        this.propagator = new ConstantDensityPropagator(this, circuit);
        circuit.addCircuitListener(new CircuitListenerAdapter(){

            public void branchRemoved(Branch branch) {
                ElectronSet.this.removeParticles(branch);
            }
        });
    }

    public double getDensity(Branch branch) {
        Electron[] electronArray = this.getParticles(branch);
        return (double)electronArray.length / branch.getLength();
    }

    public void addParticle(Electron electron) {
        this.particles.add(electron);
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).particleAdded(electron);
        }
    }

    public void clear() {
        Electron[] electronArray = this.particles.toArray(new Electron[0]);
        this.particles.clear();
        this.notifyElectronsRemoved(electronArray);
    }

    public Electron[] getParticles(Branch branch) {
        ArrayList<Electron> arrayList = new ArrayList<Electron>();
        for (Electron electron : this.particles) {
            if (electron.getBranch() != branch) continue;
            arrayList.add(electron);
        }
        return arrayList.toArray(new Electron[arrayList.size()]);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyElectronsRemoved(Electron[] electronArray) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).particlesRemoved(electronArray);
        }
    }

    public Electron[] removeParticles(Branch branch) {
        Electron[] electronArray = this.getParticles(branch);
        for (int i = 0; i < electronArray.length; ++i) {
            Electron electron = electronArray[i];
            this.particles.remove(electron);
            electron.delete();
        }
        this.notifyElectronsRemoved(electronArray);
        return electronArray;
    }

    public int numParticles() {
        return this.particles.size();
    }

    public Electron particleAt(int n) {
        return this.particles.get(n);
    }

    public void stepInTime(double d) {
        this.propagator.stepInTime(d);
    }

    public Electron getUpperNeighborInBranch(Electron electron) {
        Electron[] electronArray = this.getParticles(electron.getBranch());
        Electron electron2 = null;
        double d = Double.POSITIVE_INFINITY;
        for (Electron electron3 : electronArray) {
            double d2;
            double d3;
            double d4;
            if (electron3 == electron || !((d4 = electron3.getDistAlongWire()) > (d3 = electron.getDistAlongWire())) || !((d2 = d4 - d3) < d)) continue;
            d = d2;
            electron2 = electron3;
        }
        return electron2;
    }

    public Electron getLowerNeighborInBranch(Electron electron) {
        Electron[] electronArray = this.getParticles(electron.getBranch());
        Electron electron2 = null;
        double d = Double.POSITIVE_INFINITY;
        for (Electron electron3 : electronArray) {
            double d2;
            double d3;
            double d4;
            if (electron3 == electron || !((d4 = electron3.getDistAlongWire()) < (d3 = electron.getDistAlongWire())) || !((d2 = d3 - d4) < d)) continue;
            d = d2;
            electron2 = electron3;
        }
        return electron2;
    }

    public ConstantDensityPropagator getPropagator() {
        return this.propagator;
    }

    public static interface Listener {
        public void particlesRemoved(Electron[] var1);

        public void particleAdded(Electron var1);
    }
}

