/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model;

import edu.colorado.phet.circuitconstructionkit.model.SimpleObservableDebug;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.awt.geom.Point2D;
import java.util.Arrays;

public class Electron
extends SimpleObservableDebug {
    private Branch branch;
    private double distAlongWire;
    private Point2D position;
    private double radius = 0.1;
    private SimpleObserver observer;
    private boolean deleted = false;

    public Electron(Branch branch, double d) {
        if (Double.isNaN(d)) {
            throw new RuntimeException("Dist along wire is NaN.");
        }
        this.branch = branch;
        this.distAlongWire = d;
        if (d < 0.0 || d > branch.getLength()) {
            throw new RuntimeException("Electron out of bounds.");
        }
        this.updatePosition();
        this.observer = new Observer();
        branch.addObserver(this.observer);
    }

    private void updatePosition() {
        Point2D point2D = this.branch.getPosition(this.distAlongWire);
        if (this.isNaN(point2D)) {
            point2D = this.branch.getPosition(this.distAlongWire);
            throw new RuntimeException("Point was NaN, pt=" + point2D + ", dist=" + this.distAlongWire + ", wire length=" + this.branch.getLength());
        }
        this.position = point2D;
        this.notifyObservers();
    }

    private boolean isNaN(Point2D point2D) {
        return Double.isNaN(point2D.getX()) || Double.isNaN(point2D.getY());
    }

    public void setDistAlongWire(double d) {
        if (Double.isNaN(d)) {
            throw new RuntimeException("Dist along wire is NaN.");
        }
        if (this.getBranch().containsScalarLocation(d)) {
            if (d != this.distAlongWire) {
                this.distAlongWire = d;
                this.updatePosition();
            }
        } else {
            throw new RuntimeException("Position not in wire, x=" + d + ", length=" + this.getBranch().getLength());
        }
    }

    public void delete() {
        this.branch.removeObserver(this.observer);
        this.deleted = true;
    }

    public Branch getBranch() {
        if (this.deleted) {
            throw new RuntimeException("Already deleted!");
        }
        return this.branch;
    }

    public Point2D getPosition() {
        if (this.deleted) {
            throw new RuntimeException("Already deleted!");
        }
        if (Double.isNaN(this.position.getX()) || Double.isNaN(this.position.getY())) {
            throw new RuntimeException("Position is NaN.");
        }
        return this.position;
    }

    public double getDistAlongWire() {
        return this.distAlongWire;
    }

    public void setLocation(Branch branch, double d) {
        if (Double.isNaN(d)) {
            throw new RuntimeException("x was NaN, for electron distance along branch.");
        }
        if (!branch.containsScalarLocation(d)) {
            throw new RuntimeException("No location in branch.");
        }
        if (this.branch != branch) {
            this.branch = branch;
            this.branch.removeObserver(this.observer);
            branch.addObserver(this.observer);
        }
        if (this.distAlongWire != d) {
            this.distAlongWire = d;
            this.updatePosition();
        }
    }

    public String toString() {
        return "Electron, deleted=" + this.deleted + ", observers= " + Arrays.asList(this.getObserverList());
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public class Observer
    implements SimpleObserver {
        public void update() {
            if (this.isDeleted()) {
                new RuntimeException("Update called on deleted electron.").printStackTrace();
            }
            Electron.this.updatePosition();
        }

        public boolean isDeleted() {
            return Electron.this.isDeleted();
        }
    }
}

