/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit;

import edu.colorado.phet.circuitconstructionkit.CCKParameters;
import edu.colorado.phet.circuitconstructionkit.CCKViewState;
import edu.colorado.phet.circuitconstructionkit.controls.CCKControlPanel;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.CircuitChangeListener;
import edu.colorado.phet.circuitconstructionkit.model.ResistivityManager;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.Bulb;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.BranchNodeFactory;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CCKSimulationPanel;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CircuitNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.MeasurementToolSet;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.VoltmeterModel;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import java.awt.Color;
import java.awt.geom.Rectangle2D;

public class CCKModule
extends PiccoloModule {
    public static Color BACKGROUND_COLOR = new Color(100, 160, 255);
    private CCKModel model;
    private CCKParameters cckParameters;
    private CCKSimulationPanel cckSimulationPanel;
    private MeasurementToolSet measurementToolSet;
    private static int delay = 30;
    public static double dt = (double)delay / 1000.0;
    private CCKViewState viewState = new CCKViewState();

    public CCKModule(String[] stringArray, boolean bl, boolean bl2) {
        super("CCK-Piccolo", new SwingClock(delay, dt));
        this.cckParameters = new CCKParameters(this, stringArray, bl, bl2);
        this.setModel(new BaseModel());
        this.model = new CCKModel();
        this.measurementToolSet = new MeasurementToolSet(this.model);
        this.cckSimulationPanel = new CCKSimulationPanel(this.model, this, this.getClock());
        this.setSimulationPanel(this.cckSimulationPanel);
        this.setControlPanel(new CCKControlPanel(this, this));
        this.addModelElement(new ModelElement(){

            public void stepInTime(double d) {
                CCKModule.this.model.stepInTime(d);
            }
        });
        this.setLogoPanel(null);
    }

    public void activate() {
        super.activate();
        this.getSimulationPanel().requestFocus();
        Bulb.setHeightScale(0.375);
    }

    public Circuit getCircuit() {
        return this.model.getCircuit();
    }

    public void setLifelike(boolean bl) {
        this.getCCKViewState().getLifelikeProperty().set(bl);
    }

    public boolean isLifelike() {
        return (Boolean)this.getCCKViewState().getLifelikeProperty().get();
    }

    public CircuitChangeListener getCircuitChangeListener() {
        return this.model.getCircuitChangeListener();
    }

    public CCKParameters getParameters() {
        return this.cckParameters;
    }

    public void setVoltmeterVisible(boolean bl) {
        this.getVoltmeterModel().setVisible(bl);
    }

    public VoltmeterModel getVoltmeterModel() {
        return this.measurementToolSet.getVoltmeterModel();
    }

    public void addGrabBag() {
        this.cckSimulationPanel.addGrabBag();
    }

    public void setVirtualAmmeterVisible(boolean bl) {
        this.cckSimulationPanel.setVirtualAmmeterVisible(bl);
    }

    public void setSeriesAmmeterVisible(boolean bl) {
        this.cckSimulationPanel.setSeriesAmmeterVisible(bl);
    }

    public boolean isStopwatchVisible() {
        return false;
    }

    public void setStopwatchVisible(boolean bl) {
        this.cckSimulationPanel.setStopwatchVisible(bl);
    }

    public void addCurrentChart() {
        this.cckSimulationPanel.addCurrentChart();
    }

    public void addVoltageChart() {
        this.cckSimulationPanel.addVoltageChart();
    }

    public void setCircuit(Circuit circuit) {
        this.model.setCircuit(circuit);
    }

    public void setZoom(double d) {
        this.cckSimulationPanel.setZoom(d);
    }

    public void resetAll() {
        this.model.resetAll();
        this.viewState.resetAll();
    }

    public ResistivityManager getResistivityManager() {
        return this.model.getResistivityManager();
    }

    public boolean isElectronsVisible() {
        return this.getCircuitNode().isElectronsVisible();
    }

    private CircuitNode getCircuitNode() {
        return this.cckSimulationPanel.getCircuitNode();
    }

    public void setElectronsVisible(boolean bl) {
        this.getCircuitNode().setElectronsVisible(bl);
    }

    public Rectangle2D getModelBounds() {
        return this.model.getModelBounds();
    }

    public void layoutElectrons(Branch[] branchArray) {
        this.model.layoutElectrons(branchArray);
    }

    public void selectAll() {
        this.model.selectAll();
    }

    public void deleteSelectedBranches() {
        this.model.deleteSelectedBranches();
    }

    public void desolderSelection() {
        this.model.desolderSelectedJunctions();
    }

    public Color getMyBackground() {
        return this.cckSimulationPanel.getCCKBackground();
    }

    public void setMyBackground(Color color) {
        this.cckSimulationPanel.setCCKBackground(color);
    }

    public void setToolboxBackgroundColor(Color color) {
        this.cckSimulationPanel.setToolboxBackgroundColor(color);
    }

    public Color getToolboxBackgroundColor() {
        return this.cckSimulationPanel.getToolboxBackgroundColor();
    }

    public CCKModel getCCKModel() {
        return this.model;
    }

    public boolean isReadoutVisible(Branch branch) {
        return this.getCircuitNode().isReadoutVisible(branch);
    }

    public void setReadoutVisible(Branch branch, boolean bl) {
        branch.setEditing(bl);
    }

    public void applicationStarted() {
        this.cckSimulationPanel.applicationStarted();
    }

    public void setHelpEnabled(boolean bl) {
        super.setHelpEnabled(bl);
        this.cckSimulationPanel.setHelpEnabled(bl);
    }

    public CCKSimulationPanel getCckSimulationPanel() {
        return this.cckSimulationPanel;
    }

    public void addBranchNodeFactoryListener(BranchNodeFactory.Listener listener) {
        this.getCircuitNode().addBranchNodeFactoryListener(listener);
    }

    public CCKViewState getCCKViewState() {
        return this.viewState;
    }
}

