/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.mna.MNAAdapter;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Container;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CCKDeveloperDialog
extends JDialog {
    private final MNAAdapter solver;

    public CCKDeveloperDialog(PhetFrame phetFrame, CCKModule cCKModule) {
        super(phetFrame, "CCK Developer Dialog", false);
        this.solver = cCKModule.getCCKModel().getCircuitSolver();
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        JLabel jLabel = new JLabel("<html>These developer controls govern the behavior of the timestep subdivision algorithm, <br>and subsequently the tradeoff between accuracy and speed in the CCK model.  Their effects will only be visible in <br>a circuit which requires timestep subdivisions. Model parameters are are 10^ slider values.  See #2241</html>");
        ((Container)verticalLayoutPanel).add(jLabel);
        ((Container)verticalLayoutPanel).add(new JSeparator());
        ((Container)verticalLayoutPanel).add(new JTextArea("threshold for determining whether 2 states are similar enough;\nany error less than errorThreshold will be tolerated"));
        final LinearValueControl linearValueControl = new LinearValueControl(-10.0, -1.0, Math.log10(this.solver.getErrorThreshold()), "error threshold EXP", "0.000", "");
        linearValueControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CCKDeveloperDialog.this.solver.setErrorThreshold(Math.pow(10.0, linearValueControl.getValue()));
                CCKDeveloperDialog.this.displayValues();
            }
        });
        ((Container)verticalLayoutPanel).add(linearValueControl);
        ((Container)verticalLayoutPanel).add(new JSeparator());
        ((Container)verticalLayoutPanel).add(new JTextArea("lowest possible value for DT, independent of how the error scales with reduced time step"));
        final LinearValueControl linearValueControl2 = new LinearValueControl(-10.0, -1.0, Math.log10(this.solver.getMinDT()), "min dt EXP", "0.000", "");
        linearValueControl2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CCKDeveloperDialog.this.solver.setMinDT(Math.pow(10.0, linearValueControl2.getValue()));
            }
        });
        ((Container)verticalLayoutPanel).add(linearValueControl2);
        this.setContentPane(verticalLayoutPanel);
        this.pack();
        SwingUtils.centerDialogInParent(this);
    }

    private void displayValues() {
        System.out.println("errorThreshold = " + this.solver.getErrorThreshold() + ", minDT = " + this.solver.getMinDT());
    }
}

