/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLUtils {
    private XMLUtils() {
    }

    public static String toString(Node node) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource dOMSource = new DOMSource(node);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        transformer.transform(dOMSource, streamResult);
        return stringWriter.toString();
    }

    public static Document toDocument(String string) throws TransformerException, ParserConfigurationException {
        if (string.startsWith("\ufeff")) {
            string = string.substring(1);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        StreamSource streamSource = new StreamSource(new StringReader(string));
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        DOMResult dOMResult = new DOMResult(document);
        transformer.transform(streamSource, dOMResult);
        return document;
    }

    public static HttpURLConnection post(String string, Document document) throws IOException, UnknownHostException, TransformerException {
        return XMLUtils.post(string, XMLUtils.toString(document));
    }

    public static HttpURLConnection post(String string, String string2) throws IOException, UnknownHostException {
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
        httpURLConnection.setDoOutput(true);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream(), "UTF-8");
        outputStreamWriter.write(string2);
        outputStreamWriter.close();
        return httpURLConnection;
    }

    public static Document readDocument(HttpURLConnection httpURLConnection) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        String string = XMLUtils.readString(httpURLConnection);
        return XMLUtils.toDocument(string);
    }

    public static String readString(HttpURLConnection httpURLConnection) throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }
}

