/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model.mna;

import Jama.Matrix;
import edu.colorado.phet.circuitconstructionkit.model.mna.LinearCircuitSolution;
import edu.colorado.phet.circuitconstructionkit.model.mna.LinearCircuitSolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ObjectOrientedMNA
implements LinearCircuitSolver {
    public LinearCircuitSolver.ISolution solve(LinearCircuitSolver.Circuit circuit) {
        return new OOCircuit(circuit.batteries, circuit.resistors, circuit.currentSources).solve();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OOCircuit
    extends LinearCircuitSolver.Circuit {
        public boolean debug = false;

        OOCircuit(List<LinearCircuitSolver.Battery> list, List<LinearCircuitSolver.Resistor> list2, List<LinearCircuitSolver.CurrentSource> list3) {
            super(list, list2, list3);
        }

        int getNumVars() {
            return this.getNodeCount() + this.getCurrentCount();
        }

        double getRHS(int n) {
            double d = 0.0;
            for (LinearCircuitSolver.CurrentSource currentSource : this.currentSources) {
                if (currentSource.node1 == n) {
                    d -= currentSource.current;
                }
                if (currentSource.node0 != n) continue;
                d += currentSource.current;
            }
            return d;
        }

        ArrayList<Term> getIncomingCurrentTerms(int n) {
            ArrayList<Term> arrayList = new ArrayList<Term>();
            for (LinearCircuitSolver.Element element : this.batteries) {
                if (element.node1 != n) continue;
                arrayList.add(new Term(-1.0, new UnknownCurrent(element)));
            }
            for (LinearCircuitSolver.Element element : this.resistors) {
                if (((LinearCircuitSolver.Resistor)element).node1 != n || ((LinearCircuitSolver.Resistor)element).resistance != 0.0) continue;
                arrayList.add(new Term(-1.0, new UnknownCurrent(element)));
            }
            for (LinearCircuitSolver.Element element : this.resistors) {
                if (((LinearCircuitSolver.Resistor)element).node1 != n || ((LinearCircuitSolver.Resistor)element).resistance == 0.0) continue;
                arrayList.add(new Term(1.0 / ((LinearCircuitSolver.Resistor)element).resistance, new UnknownVoltage(((LinearCircuitSolver.Resistor)element).node1)));
                arrayList.add(new Term(-1.0 / ((LinearCircuitSolver.Resistor)element).resistance, new UnknownVoltage(((LinearCircuitSolver.Resistor)element).node0)));
            }
            return arrayList;
        }

        ArrayList<Term> getOutgoingCurrentTerms(int n) {
            ArrayList<Term> arrayList = new ArrayList<Term>();
            for (LinearCircuitSolver.Element element : this.batteries) {
                if (element.node0 != n) continue;
                arrayList.add(new Term(1.0, new UnknownCurrent(element)));
            }
            for (LinearCircuitSolver.Element element : this.resistors) {
                if (((LinearCircuitSolver.Resistor)element).node0 != n || ((LinearCircuitSolver.Resistor)element).resistance != 0.0) continue;
                arrayList.add(new Term(1.0, new UnknownCurrent(element)));
            }
            for (LinearCircuitSolver.Element element : this.resistors) {
                if (((LinearCircuitSolver.Resistor)element).node0 != n || ((LinearCircuitSolver.Resistor)element).resistance == 0.0) continue;
                arrayList.add(new Term(-1.0 / ((LinearCircuitSolver.Resistor)element).resistance, new UnknownVoltage(((LinearCircuitSolver.Resistor)element).node1)));
                arrayList.add(new Term(1.0 / ((LinearCircuitSolver.Resistor)element).resistance, new UnknownVoltage(((LinearCircuitSolver.Resistor)element).node0)));
            }
            return arrayList;
        }

        ArrayList<Term> getCurrentConservationTerms(int n) {
            ArrayList<Term> arrayList = new ArrayList<Term>();
            arrayList.addAll(this.getIncomingCurrentTerms(n));
            arrayList.addAll(this.getOutgoingCurrentTerms(n));
            return arrayList;
        }

        HashSet<Integer> getReferenceNodes() {
            HashSet<Integer> hashSet = this.getNodeSet();
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            hashSet2.addAll(hashSet);
            HashSet<Integer> hashSet3 = new HashSet<Integer>();
            while (hashSet2.size() > 0) {
                ArrayList<Integer> arrayList = this.doSort(hashSet2.toArray(new Integer[hashSet2.size()]));
                hashSet3.add(arrayList.get(0));
                HashSet<Integer> hashSet4 = this.getConnectedNodes(arrayList.get(0));
                hashSet2.removeAll(hashSet4);
            }
            return hashSet3;
        }

        private ArrayList<Integer> doSort(Integer[] integerArray) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(Arrays.asList(integerArray));
            Collections.sort(arrayList);
            return arrayList;
        }

        HashSet<Integer> getConnectedNodes(int n) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            hashSet2.add(n);
            this.getConnectedNodes(hashSet, hashSet2);
            return hashSet;
        }

        private void getConnectedNodes(HashSet<Integer> hashSet, HashSet<Integer> hashSet2) {
            while (hashSet2.size() > 0) {
                Integer n = hashSet2.toArray(new Integer[hashSet2.size()])[0];
                hashSet.add(n);
                for (LinearCircuitSolver.Element element : this.getElements()) {
                    if (!element.containsNode(n) || hashSet.contains(element.getOpposite(n))) continue;
                    hashSet2.add(element.getOpposite(n));
                }
                hashSet2.remove(n);
            }
        }

        ArrayList<Equation> getEquations() {
            ArrayList<Equation> arrayList = new ArrayList<Equation>();
            for (Integer object : this.getReferenceNodes()) {
                arrayList.add(new Equation(0.0, new Term(1.0, new UnknownVoltage(object))));
            }
            for (Integer n : this.getNodeSet()) {
                arrayList.add(new Equation(this.getRHS(n), this.getCurrentConservationTerms(n).toArray(new Term[this.getCurrentConservationTerms(n).size()])));
            }
            for (LinearCircuitSolver.Battery battery : this.batteries) {
                arrayList.add(new Equation(battery.voltage, new Term(-1.0, new UnknownVoltage(battery.node0)), new Term(1.0, new UnknownVoltage(battery.node1))));
            }
            for (LinearCircuitSolver.Resistor resistor : this.resistors) {
                if (resistor.resistance != 0.0) continue;
                arrayList.add(new Equation(0.0, new Term(1.0, new UnknownVoltage(resistor.node0)), new Term(-1.0, new UnknownVoltage(resistor.node1))));
            }
            return arrayList;
        }

        ArrayList<UnknownVoltage> getUnknownVoltages() {
            ArrayList<UnknownVoltage> arrayList = new ArrayList<UnknownVoltage>();
            for (Integer n : this.getNodeSet()) {
                arrayList.add(new UnknownVoltage(n));
            }
            return arrayList;
        }

        ArrayList<UnknownCurrent> getUnknownCurrents() {
            ArrayList<UnknownCurrent> arrayList = new ArrayList<UnknownCurrent>();
            for (LinearCircuitSolver.Element element : this.batteries) {
                arrayList.add(new UnknownCurrent(element));
            }
            for (LinearCircuitSolver.Element element : this.resistors) {
                if (((LinearCircuitSolver.Resistor)element).resistance != 0.0) continue;
                arrayList.add(new UnknownCurrent(element));
            }
            return arrayList;
        }

        ArrayList<Unknown> getUnknowns() {
            ArrayList<Unknown> arrayList = new ArrayList<Unknown>(this.getUnknownCurrents());
            arrayList.addAll(this.getUnknownVoltages());
            return arrayList;
        }

        public LinearCircuitSolver.ISolution solve() {
            ArrayList<Equation> arrayList = this.getEquations();
            Matrix matrix = new Matrix(arrayList.size(), this.getNumVars());
            Matrix matrix2 = new Matrix(arrayList.size(), 1);
            final ArrayList<Unknown> arrayList2 = this.getUnknowns();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).stamp(i, matrix, matrix2, new IndexMap(){

                    public int getIndex(Unknown unknown) {
                        return arrayList2.indexOf(unknown);
                    }
                });
            }
            if (this.debug) {
                System.out.println("Debugging circuit: " + this.toString());
                System.out.println(LinearCircuitSolver.Util.mkString(arrayList, "\n"));
                System.out.println("a=");
                matrix.print(4, 2);
                System.out.println("z=");
                matrix2.print(4, 2);
                System.out.println("unknowns=\n" + LinearCircuitSolver.Util.mkString(this.getUnknowns(), "\n"));
            }
            Matrix matrix3 = matrix.solve(matrix2);
            HashMap<Integer, Double> hashMap = new HashMap<Integer, Double>();
            for (UnknownVoltage object : this.getUnknownVoltages()) {
                hashMap.put(object.node, matrix3.get(this.getUnknowns().indexOf(object), 0));
            }
            HashMap hashMap2 = new HashMap();
            for (UnknownCurrent unknownCurrent : this.getUnknownCurrents()) {
                hashMap2.put(unknownCurrent.element, matrix3.get(this.getUnknowns().indexOf(unknownCurrent), 0));
            }
            if (this.debug) {
                System.out.println("x=");
                matrix3.print(4, 2);
            }
            return new LinearCircuitSolution(hashMap, hashMap2);
        }

        class Equation {
            double rhs;
            Term[] terms;

            Equation(double d, Term ... termArray) {
                this.rhs = d;
                this.terms = termArray;
            }

            void stamp(int n, Matrix matrix, Matrix matrix2, IndexMap indexMap) {
                matrix2.set(n, 0, this.rhs);
                for (Term term : this.terms) {
                    matrix.set(n, indexMap.getIndex(term.variable), term.coefficient + matrix.get(n, indexMap.getIndex(term.variable)));
                }
            }

            public String toString() {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Term term : this.terms) {
                    arrayList.add(term.toTermString());
                }
                String string = "" + LinearCircuitSolver.Util.mkString(arrayList, "+") + "=" + this.rhs;
                return string.replaceAll("\\+\\-", "\\-");
            }
        }

        static interface IndexMap {
            public int getIndex(Unknown var1);
        }

        public class Term {
            private final double coefficient;
            private final Unknown variable;

            public Term(double d, Unknown unknown) {
                this.coefficient = d;
                this.variable = unknown;
            }

            public String toTermString() {
                String string = this.coefficient == 1.0 ? "" : (this.coefficient == -1.0 ? "-" : this.coefficient + "*");
                return string + this.variable.toTermName();
            }
        }

        abstract class Unknown {
            Unknown() {
            }

            abstract String toTermName();
        }

        class UnknownCurrent
        extends Unknown {
            LinearCircuitSolver.Element element;

            UnknownCurrent(LinearCircuitSolver.Element element) {
                this.element = element;
            }

            String toTermName() {
                return "I" + this.element.node0 + "_" + this.element.node1;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                UnknownCurrent unknownCurrent = (UnknownCurrent)object;
                return this.element.equals(unknownCurrent.element);
            }

            public int hashCode() {
                return this.element.hashCode();
            }

            public String toString() {
                return "UnknownCurrent{element=" + this.element + '}';
            }
        }

        class UnknownVoltage
        extends Unknown {
            int node;

            UnknownVoltage(int n) {
                this.node = n;
            }

            String toTermName() {
                return "V" + this.node;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                UnknownVoltage unknownVoltage = (UnknownVoltage)object;
                return this.node == unknownVoltage.node;
            }

            public int hashCode() {
                return this.node;
            }

            public String toString() {
                return "UnknownVoltage{node=" + this.node + '}';
            }
        }
    }
}

