/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model.components;

import edu.colorado.phet.circuitconstructionkit.model.CircuitChangeListener;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class PathBranch
extends Branch {
    protected ArrayList segments = new ArrayList();
    private Point2D.Double startPoint;

    public PathBranch(CircuitChangeListener circuitChangeListener, Junction junction, Junction junction2) {
        super(circuitChangeListener, junction, junction2);
    }

    public Point2D getPosition(double d) {
        Location location = this.getLocation(d);
        return location.getPoint2D();
    }

    public Shape getShape() {
        return new BasicStroke(0.3279f, 0, 0).createStrokedShape(this.getPath());
    }

    public GeneralPath getPath() {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(this.startPoint);
        for (int i = 0; i < this.segments.size(); ++i) {
            Segment segment = (Segment)this.segments.get(i);
            doubleGeneralPath.lineTo(segment.getEnd());
        }
        return doubleGeneralPath.getGeneralPath();
    }

    public Location getLocation(double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.numSegments(); ++i) {
            Segment segment = this.segmentAt(i);
            double d3 = d2 + segment.getLength();
            if (d <= d3) {
                return new Location(segment, d - d2);
            }
            d2 += segment.getLength();
        }
        return null;
    }

    public int numSegments() {
        return this.segments.size();
    }

    public Segment segmentAt(int n) {
        return (Segment)this.segments.get(n);
    }

    public double getLength() {
        double d = 0.0;
        for (int i = 0; i < this.segments.size(); ++i) {
            Segment segment = (Segment)this.segments.get(i);
            d += segment.getLength();
        }
        if (Double.isNaN(d)) {
            throw new RuntimeException("Length is NaN");
        }
        return d;
    }

    public void reset(Point2D point2D, Point2D point2D2) {
        this.segments.clear();
        Segment segment = new Segment(point2D, point2D2);
        this.segments.add(segment);
    }

    public void addPoint(Point2D point2D) {
        Segment segment = new Segment(this.lastPoint(), point2D);
        this.segments.add(segment);
    }

    public Point2D lastPoint() {
        return this.segmentAt(this.numSegments() - 1).getEnd();
    }

    public void addPoint(ImmutableVector2D immutableVector2D) {
        Point2D.Double double_ = immutableVector2D.getDestination(this.lastPoint());
        this.addPoint(double_);
    }

    public class Location {
        private Segment segment;
        private double distAlongSegment;

        public Location(Segment segment, double d) {
            this.segment = segment;
            this.distAlongSegment = d;
        }

        public Point2D getPoint2D() {
            ImmutableVector2D immutableVector2D = new Vector2D(this.segment.getStart(), this.segment.getEnd());
            immutableVector2D = immutableVector2D.getInstanceOfMagnitude(this.distAlongSegment);
            return immutableVector2D.getDestination(this.segment.getStart());
        }
    }

    public static class Segment {
        Point2D start;
        Point2D end;

        public Segment(Point2D point2D, Point2D point2D2) {
            this.start = point2D;
            this.end = point2D2;
            if (Double.isNaN(point2D.getX()) || Double.isNaN(point2D.getY())) {
                throw new RuntimeException("Start was NaN: " + point2D);
            }
            if (Double.isNaN(point2D2.getX()) || Double.isNaN(point2D2.getY())) {
                throw new RuntimeException("end was NaN: " + point2D2);
            }
        }

        public Point2D getStart() {
            return this.start;
        }

        public Point2D getEnd() {
            return this.end;
        }

        public double getLength() {
            double d = this.start.distance(this.end);
            if (Double.isNaN(d)) {
                throw new RuntimeException(" Length was NaN.");
            }
            return d;
        }
    }
}

