/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.controls;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class AdvancedPanel
extends VerticalLayoutPanel {
    private JButton showButton;
    private JButton hideButton;
    private VerticalLayoutPanel controls;
    ArrayList listeners = new ArrayList();

    public AdvancedPanel() {
        this("Advanced >>", "Hide <<");
    }

    public AdvancedPanel(String string, String string2) {
        this.controls = new VerticalLayoutPanel();
        this.controls.setFillNone();
        this.showButton = new JButton(string);
        this.showButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPanel.this.showAdvanced();
            }
        });
        this.hideButton = new JButton(string2);
        this.hideButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPanel.this.hideAdvanced();
            }
        });
        this.setFillNone();
        this.add(this.showButton);
        this.add(this.hideButton);
        this.setFillHorizontal();
        this.add(this.controls);
        this.controls.setVisible(false);
        this.hideButton.setVisible(false);
    }

    public void addControl(JComponent jComponent) {
        this.controls.add(jComponent);
    }

    private void showAdvanced() {
        this.showButton.setVisible(false);
        this.controls.setVisible(true);
        this.hideButton.setVisible(true);
        this.validateAll();
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.advancedPanelShown(this);
        }
        this.validateAll();
        this.validate();
    }

    private void validateAll() {
        this.invalidate();
        this.controls.invalidate();
        if (this.getParent() != null) {
            this.getParent().invalidate();
            if (this.getParent().getParent() != null) {
                this.getParent().getParent().invalidate();
                this.getParent().getParent().validate();
            }
        }
        Window window = SwingUtilities.getWindowAncestor(this);
        window.invalidate();
        window.validate();
        window.repaint();
    }

    private void hideAdvanced() {
        this.hideButton.setVisible(false);
        this.controls.setVisible(false);
        this.showButton.setVisible(true);
        this.validateAll();
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.advancedPanelHidden(this);
        }
        this.validateAll();
        this.validate();
    }

    public static interface Listener {
        public void advancedPanelHidden(AdvancedPanel var1);

        public void advancedPanelShown(AdvancedPanel var1);
    }
}

