/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import java.util.Arrays;

public class CCKParameters {
    private String[] args;
    private boolean virtualLab = false;
    private boolean grabBag = true;
    private boolean allowPlainResistors = true;
    private boolean hugeBatteries = true;
    private boolean allowShowReadouts = true;
    private boolean allowSchematicMode = true;
    private boolean useAdvancedControlPanel = true;
    private boolean useNonContactAmmeter = true;
    private boolean hideAllElectrons = false;
    private boolean grabBagMode = false;
    private boolean useVisualControlPanel = true;
    private boolean dynamics = false;

    public CCKParameters(CCKModule cCKModule, String[] stringArray, boolean bl, boolean bl2) {
        this.args = stringArray;
        if (bl) {
            this.dynamics = true;
        }
        if (bl2) {
            bl2 = true;
        }
        if (this.containsArg("-grabbag")) {
            this.grabBagMode = true;
        }
        if (this.containsArg("-noElectrons")) {
            cCKModule.setElectronsVisible(false);
            this.hideAllElectrons = true;
        }
        if (this.containsArg("-exp1")) {
            cCKModule.setElectronsVisible(true);
            this.hideAllElectrons = false;
            this.allowSchematicMode = false;
            this.useNonContactAmmeter = false;
            this.grabBag = true;
            this.hugeBatteries = false;
            this.allowPlainResistors = true;
            this.useAdvancedControlPanel = false;
            this.useVisualControlPanel = false;
        } else if (this.containsArg("-exp2")) {
            cCKModule.setElectronsVisible(false);
            this.hideAllElectrons = true;
            this.allowSchematicMode = false;
            this.useNonContactAmmeter = false;
            this.grabBag = true;
            this.hugeBatteries = false;
            this.allowPlainResistors = true;
            this.useAdvancedControlPanel = false;
            this.useVisualControlPanel = false;
        }
        if (bl2) {
            this.allowShowReadouts = false;
            this.allowSchematicMode = false;
            this.useNonContactAmmeter = false;
        }
        if (this.grabBagMode) {
            this.grabBag = true;
            this.hugeBatteries = true;
            this.allowPlainResistors = false;
            this.allowShowReadouts = true;
            this.allowSchematicMode = false;
            this.useAdvancedControlPanel = false;
            this.useNonContactAmmeter = true;
            this.hideAllElectrons = false;
        }
    }

    public boolean isUseVisualControlPanel() {
        return this.useVisualControlPanel;
    }

    private boolean containsArg(String string) {
        return Arrays.asList(this.args).contains(string);
    }

    public boolean useNonContactAmmeter() {
        return this.useNonContactAmmeter;
    }

    public boolean showGrabBag() {
        return this.grabBag;
    }

    public boolean allowSchematicMode() {
        return this.allowSchematicMode;
    }

    public boolean allowShowReadouts() {
        return this.allowShowReadouts;
    }

    public boolean hugeRangeOnBatteries() {
        return this.hugeBatteries;
    }

    public boolean getUseAdvancedControlPanel() {
        return this.useAdvancedControlPanel;
    }

    public boolean getAllowDynamics() {
        return this.dynamics;
    }
}

