function Decoder(bytes, port) {
  // Initialize the data object
  
  // Parse Country ID
  var country_ID = parseInt(bytes[0]-48);
  
  // Parse weatherstation ID
  var weatherstation_ID = parseInt(bytes[1]-48);
  
  //Parse temperature sign
  var sign = parseInt(bytes[2]-48);
  
  // Parse the temperature in Celsius
  var Temperature_Celsius = (
    10*parseInt(bytes[3]-48) + 
    1*parseInt(bytes[4]-48) + 
    0.1*parseInt(bytes[5]-48) + 
    0.01 *parseInt(bytes[6]-48)
  );
  
  // Parse the relative humidity percentage
  var Relative_Humidity_Percentage = (
    100*parseInt(bytes[7]-48) + 
    10*parseInt(bytes[8]-48) + 
    1 *parseInt(bytes[9]-48) + 
    0.1*parseInt(bytes[10]-48) + 
    0.01*parseInt(bytes[11]-48)
  );
    
  
  // Parse the pressure in hPa
  var  Pressure_hPa = (
    1000*parseInt(bytes[12]-48) + 
    100*parseInt(bytes[13]-48) + 
    10 *parseInt(bytes[14]-48) + 
    1* parseInt(bytes[15]-48) + 
    0.1* parseInt(bytes[16]-48) 
    + 0.01 *parseInt(bytes[17] -48)
  );
  

  // Parse the air quality index
  var AirQualityIndex = 1 *parseInt(bytes[18]-48);
  
  // Parse the volatile organic compounds in ppb
  var  VolatileOrganicCompounds_ppb = (
    10000*parseInt(bytes[19]-48) + 
    1000*parseInt(bytes[20]-48) + 
    100 *parseInt(bytes[21]-48) + 
    10*parseInt(bytes[22]-48) + 
    1*parseInt(bytes[23]-48)
  );
  
  // Parse the environmental CO2 level
  var  EnviromentalCO2_ppb = (
    1000*parseInt(bytes[24]-48) + 
    100*parseInt(bytes[25]-48) + 
    100 *parseInt(bytes[26]-48) + 
    10*parseInt(bytes[27]-48) + 
    1*parseInt(bytes[28]-48)
  );
  
 
  // If the temperature sign is 2, make the temperature negative
  if ( sign == 2) {
    Temperature_Celsius = Temperature_Celsius * -1;
  }
  
  // Return the data object
  return {
    //data: data,
    field1 : country_ID,
    field2 : weatherstation_ID,
    field3 : Temperature_Celsius,
    field4 : Relative_Humidity_Percentage,
    field5 : Pressure_hPa,
    field6 : AirQualityIndex,
    field7 : VolatileOrganicCompounds_ppb,
    field8 : EnviromentalCO2_ppb,
    };
}