# Software for scanning sensors/ICs on the I2C port
# Martin Loercks, May 2025

import machine

I2C_INTERFACE = 0 # alternative 1
I2C_SDA_PIN = 8 #Channel 0: PIN 8 and for Channel 1: PIN 6
I2C_SCL_PIN = 9 #Channel 0: PIN 9 and for Channel 1: PIN 7


i2c = machine.I2C(I2C_INTERFACE, sda = machine.Pin(I2C_SDA_PIN), scl = machine.Pin(I2C_SCL_PIN), freq=400000)

print('Scanning I2C bus ...')
devices = i2c.scan() # this return a list of connected devices

device_count = len(devices)

if device_count == 0:
    print('No I2C device found.')
else:
    print(device_count,' device(s) found.')
    
for device in devices:
    print('Decimal address:', device, "Hex adress: ", hex(device))
    
    
    