# Software for checking the Lorawan module
# it is based on the weather station software from core electronics in Australia
# Martin Loercks, May 2025

from machine import UART, Pin
from utime import sleep_ms

#------------------------------------------------------------------------------------------------------------

# Initialise the communication location and Baud Rate for communicating through UART1 to the PC 
uart = UART(0, 9600) 
# Initialise the communication location and Baud Rate for communicating through UART1 to the LORA Trasmitter
uart1 = UART(0, baudrate=9600, tx=Pin(0), rx=Pin(1))

#------------------------------------------------------------------------------------------------------------

def receive_uart():
    '''Polls the uart until all data is dequeued'''
    rxData=bytes()
    while uart1.any()>0:
        rxData += uart1.read(1)
        sleep_ms(2)
    return rxData.decode('utf-8')

def test_uart_connection():
    '''Checks for good UART connection by querying the LoRa-E5 module with a test command'''
    send_AT('') # empty at command will query status
    data = receive_uart()
    if data == '+AT: OK\r\n' : print('LoRa radio is ready\n')
    else:
        print('LoRa-E5 is not detected\n')
 
def send_AT(command):
    '''Wraps the "command" string with AT+ and \r\n'''
    buffer = 'AT' + command + '\r\n'
    uart1.write(buffer)
    sleep_ms(300)
        
#------------------------------------------------------------------------------------------------------------
# Main()
#------------------------------------------------------------------------------------------------------------
while True:
    test_uart_connection()
    sleep_ms(1000)
