//***************************************************************//
//                                                               //
// Het programmeren van een ultrasone sensor                     //
//                                                               //
// Onderdeel van de module Physical Computing                    //
// Ontworpen voor het vak informatica                            //
// 2017-2018                                                     //
//                                                               //
// Leest de afstand van de ultrasone sensor t.o.v. een voorwerp  //
// en laat dit zien via de seriële uitgang                       //
//                                                               //
//***************************************************************//
 
// ********************************************************
// Pin toewijzing
// ********************************************************
 
// De triggerpin
const int trigPin = 3;
 
// De echopin
const int echoPin = 2;
 
 
// ********************************************************
// Variabelen
// ********************************************************
 
// De variabele tijdsduur meet de tijd in microseconden
// tussen het trigger signaal en de ontvangen echo
long tijdsduur;
 
// De variabele afstand wordt berekend uit de tijdsduur
int afstand;
 
// We beginnen bij toestand 1
int toestand = 1;
 
 
// ********************************************************
// De setup
// ********************************************************
 
void setup() {
  // Initialiseert de trigPin als een output.
  // Daarmee geven we aan dat de trigPin (pin 3) gebruikt
  // wordt om een signaal vanuit de computer aan
  // een ander onderdeel door te geven.
  pinMode(trigPin, OUTPUT);
 
  // Initialiseert de echoPin als een input.
  // Daarmee geven we aan dat de echoPin (pin 2) gebruikt
  // wordt om een signaal aan de computer door te geven
  pinMode(echoPin, INPUT);
 
  // Om de waarden te kunnen uitlezen maken we gebruik van
  // de seriële monitor. De seriële monitor maakt gebruik
  // van de USB kabel tussen Arduino en de computer. Zo kunnen
  // we op het scherm de waarden die we willen zien lezen.
  Serial.begin(9600); // Starts the serial communication
}
 
// ********************************************************
// De loop
// ********************************************************
 
void loop() {
  
  // De trigPin wordt gedurende 2 ms op 0 gezet
  // Om de meting te starten moet hij minimaal 10 ms een hoog
  // signaal (dus een 1) hebben. 
  // Die eerste 2 ms zorgt ervoor dat de start van die 10 ms
  // duidelijk is.
  digitalWrite(trigPin, 0);
  delayMicroseconds(2);
  
  // Nu krijgt de trigPin gedurende 10 ms een hoog signaal
  // Dit zorgt ervoor dat er door de Tx (transmitter) een 
  // geluid van 8 pulsjes van 40 kHz wordt uitgezonden. 
  digitalWrite(trigPin, 1);
  delayMicroseconds(10);
  digitalWrite(trigPin, 0);
  
  // De Rx (receiver) van de sensor luistert of er geluid
  // wordt teruggekaatst. Als dat het geval is krijgt de echoPin
  // de waarde 1.
  // De pulseIn opdracht leest het signaal op de echoPin.
  // Als de echoPin een 1 wordt begint de tijd te lopen.
  // Als de echoPin weer 0 wordt, krijgt de variabele tijdsduur
  // de tijd in microseconden.
  tijdsduur = pulseIn(echoPin, 1);
  
  // Nu moeten we de microseconden omrekenen naar centimeters.
  // We gaan daarbij uit de snelheid van het geluid door lucht.
  // Dit is 340 m/s. 
  // Oftewel 34000 cm/s.
  // Dit is 34000/1.000.000 cm/μs en dit is 0,034 cm/μs.
  // 
  // Maar als we de tijdsduur weten is dat wel de tijd die het
  // geluid aflegt naar het voorwerp toe en weer terug.
  // Dus voor de afstand van het voorwerp moeten we dat nog
  // delen door 2 
  afstand = tijdsduur*0.034/2;
  
  // En dan sturen we de gegevens naar de seriële monitor
  Serial.print("Afstand: ");
  Serial.println(afstand);
}
