//***************************************************************//
//                                                               //
// Het programmeren van een PIR sensor                           //
//                                                               //
// Onderdeel van de module Physical Computing                    //
// Ontworpen voor het vak informatica                            //
// 2017-2018                                                     //
//                                                               //
// Schakelt de ingebouwde led op de Arduino aan als er een       //
// persoon gedetecteerd wordt                                    //
//                                                               //
//***************************************************************//


// ********************************************************
// Pin toewijzing
// ********************************************************

// Het ledje op de Arduino
const int ledPin = 13;
// De aansluiting van de PIR sensor
const int pirPin = 2;


// ********************************************************
// Variabelen
// ********************************************************

// De variabele pirToestand geeft aan of er beweging gedetecteerd is.
// Is de waarde 0 dan is er geen beweging gedetecteerd.
// Is de waarde 1 dan is er wel beweging gedetecteerd.
int pirToestand = 0 ;

// In het toestandsdiagram zien we 2 toestanden:
//
//  1 Het ledje is uit
//  2 Het ledje is aan
//
// We beginnen bij toestand 1
int toestand = 1;


// ********************************************************
// De setup
// ********************************************************

void setup() {
  // Initialiseert de pirPin als een input.
  // Daarmee geven we aan dat de pirPin (pin 2) gebruikt
  // wordt om een signaal aan de computer door te geven.
  pinMode(pirPin, INPUT);

  // Initialiseert de ledPin als een output.
  // Daarmee geven we aan dat de ledPin (pin 13) gebruikt
  // wordt om een signaal vanuit de computer aan
  // een ander onderdeel door te geven
  pinMode(ledPin, OUTPUT);
}


// ********************************************************
// De loop
// ********************************************************

void loop() {
  // Lees de waarde die de PIR sensor afgeeft:
  pirToestand = digitalRead(pirPin);

  if (toestand == 1) {
    if (pirToestand == 1) {
      // Ga nu naar toestand 2
      toestand = 2;
      // en zet het ledje aan
      digitalWrite(ledPin, 1);
    }
  }

  if (toestand == 2) {
    if (pirToestand == 0) {
      // Ga nu naar toestand 1
      toestand = 1;
      // en zet de lamp uit
      digitalWrite(ledPin, 0);
    }
  }
}
