//***************************************************************//
//                                                               //
// Het programmeren van een knipperend lampje met een timer      //
//                                                               //
// Onderdeel van de module Physical Computing                    //
// Ontworpen voor het vak informatica                            //
// 2019                                                          //
//                                                               //
//                                                               //
//***************************************************************//

// ********************************************************
// Pin toewijzing
// ********************************************************

// Het ledje op de Arduino
const int ledPin = 13;

// ********************************************************
// Variabelen
// ********************************************************

// De variabele toestand houdt bij in welke toestand het systeem is
// Toestand 1 betekent: ledje is uit
// Toestand 2 betekent: ledje is aan
int toestand = 1;

// De eindTimer wordt gebruikt om de eindtijd
// van de timer in bij te houden
unsigned long eindTimer = 0;

// ********************************************************
// De setup
// ********************************************************

void setup() {
  // Initialiseert de ledPin als een output.
  // Daarmee geven we aan dat de ledPin (pin 13) gebruikt
  // wordt om een signaal vanuit de computer aan
  // een ander onderdeel door te geven
  pinMode(ledPin, OUTPUT);

  // start de timer (1 seconden = 1000 milliseconden)
  eindTimer = millis() + 1000;
}


// ********************************************************
// De loop
// ********************************************************

void loop() {

  if (toestand == 1) {
    if (millis() >= eindTimer) {
      // start de timer opnieuw
      eindTimer = millis() + 1000;
      // verander de toestand
      toestand = 2;
      // en zet het ledje aan
      digitalWrite(ledPin, 1);
    }
  }

  if (toestand == 2) {
    if (millis() >= eindTimer) {
      // start de timer opnieuw
      eindTimer = millis() + 1000;
      // verander de toestand
      toestand = 1;
      // en zet het ledje aan
      digitalWrite(ledPin, 0);
    }
  }

}
