//***************************************************************//
//                                                               //
// Het programmeren van een aanraaksensor 1                      //
//                                                               //
// Onderdeel van de module Physical Computing                    //
// Ontworpen voor het vak informatica                            //
// 2017-2018                                                     //
//                                                               //
// Schakelt de ingebouwde led op de Arduino aan en uit           //
// met behulp van een capacitieve aanraakschakelaar              //
//                                                               //
//***************************************************************//

// ********************************************************
// Pin toewijzing
// De pinnen zijn de vierkante openingen waar je de
// draadjes in kunt prikken
// We gebruiken in deze code de pinnen 2 en 13
// In de schakeling heb je gezien dat we aan pin 13 
// geen draadje hebben aangesloten.
// Dat is nu niet nodig omdat het ingebouwde ledje van de
// Arduino ook aan pin 13 zit.
// ********************************************************

// Het ledje op de Arduino
// We geven aan pin 13 hier de naam ledPin
// Met die naam kunnen we pin 13 aanroepen in de code
const int ledPin = 13;

// De aansluiting van de sensor
// We geven aan pin 2 de naam sensorPin
// Met die naam kunnen we pin 2 aanroepen in de code
const int sensorPin = 2;


// ********************************************************
// Variabelen
// Een variabele is een plekje in het geheugen
// Door dat plekje een naam te geven kunnen we hem
// aanroepen en bijvoorbeeld een waarde geven.
// Of de waarde die dat plekje heeft opvragen of wijzigen.
// Hier gebruiken we de variabelen aanraken en toestand.
// ********************************************************

// De variabele aanraken geeft aan of de sensor aangeraakt wordt.
// Is de waarde 0 dan wordt hij niet aangeraakt.
// Is de waarde 1 dan wordt de sensor aangeraakt.
int aanraken = 0;

// In het toestandsdiagram zien we 2 toestanden:
//
//  1 Het ledje is uit
//  2 Het ledje is aan
//
// We moeten in het programma bijhouden in welke toestand
// de schakeling is.
// We beginnen bij toestand 1
int toestand = 1;


// ********************************************************
// De setup
// In dit deel geven we aan waar we de sensorPin en de
// ledPin voor gebruikt wordt. 
// Bij iedere gebruikte pin moet je aangeven of je er een
// signaal aan de computer wilt geven of juist of er een
// signaal vanuit de computer naar bijvoorbeeld een ledje
// moet worden gestuurd.
// Een signaal is in feite een spanning waardoor er een 
// stroompje kan vloeien. Voor de Arduino UNO is het een
// spanning van 5 volt.
// ********************************************************

void setup() {
  // Initialiseert de sensorPin als een input.
  // Daarmee geven we aan dat de sensorPin (pin 2) gebruikt
  // wordt om een signaal aan de computer door te geven.
  pinMode(sensorPin, INPUT);

  // Initialiseert de ledPin als een output.
  // Daarmee geven we aan dat de ledPin (pin 13) gebruikt
  // wordt om een signaal vanuit de computer aan
  // een ander onderdeel door te geven.
  pinMode(ledPin, OUTPUT);
}

// ********************************************************
// De loop
// De loop of lus is een stukje code dat continu van boven
// naar beneden wordt doorlopen.
// Zodra de laatste regel code van de loop is geweest
// begint hij weer bij het begin van de loop.
// ********************************************************

void loop()  {
  // Lees de sensorPin
  // Die geeft de waarde van de aanraakschakelaar
  // Een waarde 0 of LOW geeft aan dat de aanraakschakelaar
  // niet wordt aangeraakt.
  // Een waarde 1 of HIGH geeft aan dat de aanraakschakelaar
  // wel wordt aangeraakt.
  aanraken = digitalRead(sensorPin);

  // Doorloop nu het toestandsdiagram
  if (toestand == 1) {
    if (aanraken == 1) {
      // Ga nu naar toestand 2
      toestand = 2;
      // en zet het ledje aan
      digitalWrite(ledPin, 1);
    }
  }
  if (toestand == 2) {
    if (aanraken == 0) {
      // Ga nu naar toestand 1
      toestand = 1;
      // en zet het ledje uit
      digitalWrite(ledPin, 0);
    }
  }
}
